%This program is used to compute the ATS for AR(2) cases by using CUSUM.
%u0,s0 are the mean function and variance function estimated from IC data.
%u,s are the speicified mean function and variance function.
%k is the reference value
%h is the control limit
%phi1,phi2 are the coefficients of AR(2) model
%m out of n is the sampling rate

function [ats,count]=ATS_Dar2(u0,s0,u,s,k,h,phi1,phi2,m,n)
L=length(u0);
for i=1:ceil(L/n)
    A=randperm(n);
    B(((i-1)*m+1):((i-1)*m+m))=(i-1)*n+sort(A(1:m));
end
% B(1)=1;
B(ceil(L/n)*m+1)=L+1;
T=B(1);
count=1;
x=u(T)+s(T)*normrnd(0,1);
Cn=max(0,(x-u0(T))/s0(T)-k);
while (Cn<=h && T<=L)
    T=B(count+1);
if T>=L+1
    ats=T;
    break
else
    x_2=normrnd(0,1);
    x_1=phi1*x_2+normrnd(0,sqrt(5/12));
    for i=B(count)+2:T
    x_0=phi1*x_1+phi2*x_2+normrnd(0,sqrt(5/12));
    x_2=x_1;x_1=x_0;
    end
x=u(T)+s(T)*x_1;
count=count+1;
Cn=max(0,Cn+(x-u0(T))/s0(T)-k);
end
end
if T>=L+1
    ats=T;
else
ats=T-B(1);
end
